<?php
/**
 * Theme Custom Post Type(CPTs)
 * @package Flynext
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}

if (!class_exists('Flynext_Custom_Post_Type')) {
    class Flynext_Custom_Post_Type
    {

        //$instance variable
        private static $instance;

        public function __construct()
        {
            //register post type
            add_action('init', array($this, 'register_custom_post_type'));
        }

        /**
         * get Instance
         * @since  2.0.0
         */
        public static function getInstance()
        {
            if (null == self::$instance) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        /**
         * Register Custom Post Type
         * @since  2.0.0
         */
        public function register_custom_post_type()
        {
            if (!defined('ELEMENTOR_VERSION')) {
                return;
            }
            $all_post_type = array(
                [
                    'post_type' => 'service',
                    'args' => array(
                        'label' => esc_html__('Service', 'flynext-core'),
                        'description' => esc_html__('Service', 'flynext-core'),
                        'labels' => array(
                            'name' => esc_html_x('Service', 'Post Type General Name', 'flynext-core'),
                            'singular_name' => esc_html_x('Service', 'Post Type Singular Name', 'flynext-core'),
                            'menu_name' => esc_html__('Service', 'flynext-core'),
                            'all_items' => esc_html__('Services', 'flynext-core'),
                            'view_item' => esc_html__('View Service', 'flynext-core'),
                            'add_new_item' => esc_html__('Add New Service', 'flynext-core'),
                            'add_new' => esc_html__('Add New Service', 'flynext-core'),
                            'edit_item' => esc_html__('Edit Service', 'flynext-core'),
                            'update_item' => esc_html__('Update Service', 'flynext-core'),
                            'search_items' => esc_html__('Search Service', 'flynext-core'),
                            'not_found' => esc_html__('Not Found', 'flynext-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'flynext-core'),
                            'featured_image' => esc_html__('Service Image', 'flynext-core'),
                            'remove_featured_image' => esc_html__('Remove Service Image', 'flynext-core'),
                            'set_featured_image' => esc_html__('Set Service Image', 'flynext-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'taxonomies' => array( 'post_tag'), // this is IMPORTANT
                        'hierarchical' => false,
                        'public' => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => 'flynext_theme_options',
                        "rewrite" => array('slug' => 'all-services', 'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true
                    )
                ],
                [
                    'post_type' => 'packages',
                    'args' => array(
                        'label' => esc_html__('Packages', 'flynext-core'),
                        'description' => esc_html__('Packages', 'flynext-core'),
                        'labels' => array(
                            'name' => esc_html_x('Packages', 'Post Type General Name', 'flynext-core'),
                            'singular_name' => esc_html_x('Packages', 'Post Type Singular Name', 'flynext-core'),
                            'menu_name' => esc_html__('Packages', 'flynext-core'),
                            'all_items' => esc_html__('Packagess', 'flynext-core'),
                            'view_item' => esc_html__('View Packages', 'flynext-core'),
                            'add_new_item' => esc_html__('Add New Packages', 'flynext-core'),
                            'add_new' => esc_html__('Add New Packages', 'flynext-core'),
                            'edit_item' => esc_html__('Edit Packages', 'flynext-core'),
                            'update_item' => esc_html__('Update Packages', 'flynext-core'),
                            'search_items' => esc_html__('Search Packages', 'flynext-core'),
                            'not_found' => esc_html__('Not Found', 'flynext-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'flynext-core'),
                            'featured_image' => esc_html__('Packages Image', 'flynext-core'),
                            'remove_featured_image' => esc_html__('Remove Packages Image', 'flynext-core'),
                            'set_featured_image' => esc_html__('Set Packages Image', 'flynext-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'hierarchical' => false,
                        'public' => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => 'flynext_theme_options',
                        "rewrite" => array('slug' => 'all-packages', 'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true
                    )
                ],
                [
                    'post_type' => 'deals',
                    'args' => array(
                        'label' => esc_html__('Deals', 'flynext-core'),
                        'description' => esc_html__('Deals', 'flynext-core'),
                        'labels' => array(
                            'name' => esc_html_x('Deals', 'Post Type General Name', 'flynext-core'),
                            'singular_name' => esc_html_x('Deals', 'Post Type Singular Name', 'flynext-core'),
                            'menu_name' => esc_html__('Deals', 'flynext-core'),
                            'all_items' => esc_html__('Deals', 'flynext-core'),
                            'view_item' => esc_html__('View Deals', 'flynext-core'),
                            'add_new_item' => esc_html__('Add New Deals', 'flynext-core'),
                            'add_new' => esc_html__('Add New Deals', 'flynext-core'),
                            'edit_item' => esc_html__('Edit Deals', 'flynext-core'),
                            'update_item' => esc_html__('Update Deals', 'flynext-core'),
                            'search_items' => esc_html__('Search Deals', 'flynext-core'),
                            'not_found' => esc_html__('Not Found', 'flynext-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'flynext-core'),
                            'featured_image' => esc_html__('Deals Image', 'flynext-core'),
                            'remove_featured_image' => esc_html__('Remove Deals Image', 'flynext-core'),
                            'set_featured_image' => esc_html__('Set Deals Image', 'flynext-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'hierarchical' => false,
                        'public' => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => 'flynext_theme_options',
                        "rewrite" => array('slug' => 'all-deals', 'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true
                    )
                ],
                [
                    'post_type' => 'team',
                    'args' => array(
                        'label' => esc_html__('team', 'flynext-core'),
                        'description' => esc_html__('team', 'flynext-core'),
                        'labels' => array(
                            'name' => esc_html_x('Team', 'Post Type General Name', 'flynext-core'),
                            'singular_name' => esc_html_x('Team', 'Post Type Singular Name', 'flynext-core'),
                            'menu_name' => esc_html__('Teams', 'flynext-core'),
                            'all_items' => esc_html__('Teams', 'flynext-core'),
                            'view_item' => esc_html__('View Teams', 'flynext-core'),
                            'add_new_item' => esc_html__('Add New Team Member', 'flynext-core'),
                            'add_new' => esc_html__('Add New Team Member', 'flynext-core'),
                            'edit_item' => esc_html__('Edit Team', 'flynext-core'),
                            'update_item' => esc_html__('Update Team', 'flynext-core'),
                            'search_items' => esc_html__('Search Team', 'flynext-core'),
                            'not_found' => esc_html__('Not Found', 'flynext-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'flynext-core'),
                            'featured_image' => esc_html__('Team Image', 'flynext-core'),
                            'remove_featured_image' => esc_html__('Remove Team Image', 'flynext-core'),
                            'set_featured_image' => esc_html__('Set Team Image', 'flynext-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'hierarchical' => false,
                        'public' => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => 'flynext_theme_options',
                        "rewrite" => array('slug' => 'all-team', 'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true
                    )
                ]
            );

            if (!empty($all_post_type) && is_array($all_post_type)) {

                foreach ($all_post_type as $post_type) {
                    call_user_func_array('register_post_type', $post_type);
                }
            }


            /**
             * Custom Taxonomy Register
             * @since 1.0.0
            */

            $all_custom_taxonmy = array(
                array(
                    'taxonomy' => 'service-cat',
                    'object_type' => 'service',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Service Category", 'flynext-core'),
                            "singular_name" => esc_html__("Service Category", 'flynext-core'),
                            "menu_name" => esc_html__("Service Category", 'flynext-core'),
                            "all_items" => esc_html__("All Service Category", 'flynext-core'),
                            "add_new_item" => esc_html__("Add New Service Category", 'flynext-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'service-cat', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                ),
                array(
                    'taxonomy' => 'packages-cat',
                    'object_type' => 'packages',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Packages Category", 'flynext-core'),
                            "singular_name" => esc_html__("Packages Category", 'flynext-core'),
                            "menu_name" => esc_html__("Packages Category", 'flynext-core'),
                            "all_items" => esc_html__("All Packages Category", 'flynext-core'),
                            "add_new_item" => esc_html__("Add New Packages Category", 'flynext-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'packages-cat', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                ),
                array(
                    'taxonomy' => 'deals-cat',
                    'object_type' => 'deals',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Deals Category", 'flynext-core'),
                            "singular_name" => esc_html__("Deals Category", 'flynext-core'),
                            "menu_name" => esc_html__("Deals Category", 'flynext-core'),
                            "all_items" => esc_html__("All Deals Category", 'flynext-core'),
                            "add_new_item" => esc_html__("Add New Deals Category", 'flynext-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'deals-cat', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                ),
                array(
                    'taxonomy' => 'team-cat',
                    'object_type' => 'team',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Team Category", 'flynext-core'),
                            "singular_name" => esc_html__("Team Category", 'flynext-core'),
                            "menu_name" => esc_html__("Team Category", 'flynext-core'),
                            "all_items" => esc_html__("All Team Category", 'flynext-core'),
                            "add_new_item" => esc_html__("Add New Team Category", 'flynext-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'team-cat', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                )
            );

            if (is_array($all_custom_taxonmy) && !empty($all_custom_taxonmy)) {
                foreach ($all_custom_taxonmy as $taxonomy) {
                    call_user_func_array('register_taxonomy', $taxonomy);
                }
            }

            flush_rewrite_rules();
        }

    }//end class

    if (class_exists('Flynext_Custom_Post_Type')) {
        Flynext_Custom_Post_Type::getInstance();
    }
}