<?php
/**
 * Elementor Widget
 * @package Flynext
 * @since 1.0.0
 */


namespace Elementor;

class Flynext_Counterup_Two_Widget extends Widget_Base {


	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *

	 */

	public function get_name() {

		return 'flynext-counterup-two-widget';

	}


	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *

	 */

	public function get_title() {

		return esc_html__( 'Counterup: 02', 'flynext-core' );

	}


	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *

	 */

	public function get_icon() {

		return 'eicon-counter';

	}


	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @return array Widget categories.
	 * @since 1.0.0
	 * @access public
	 *

	 */

	public function get_categories() {

		return [ 'flynext_widgets' ];

	}


	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */

	protected function register_controls() {


		$this->start_controls_section(

			'settings_section',

			[

				'label' => esc_html__( 'General Settings', 'flynext-core' ),

				'tab' => Controls_Manager::TAB_CONTENT,

			]

		);


		$this->add_control(

			'theme',

			[

				'label' => esc_html__( 'Theme', 'flynext-core' ),

				'type' => Controls_Manager::SELECT,

				'options' => [

					'black' => esc_html__( 'Black', 'flynext-core' ),

					'white' => esc_html__( 'White', 'flynext-core' ),

				],

				'default' => 'black',

				'description' => esc_html__( 'select theme.', 'flynext-core' )

			]

		);

		$this->add_control(

			'icon',

			[

				'label' => esc_html__( 'Icon', 'flynext-core' ),

				'type' => Controls_Manager::ICONS,

				'description' => esc_html__( 'select Icon.', 'flynext-core' ),

				'default' => [

					'value' => 'flaticon-safe',

					'library' => 'solid',

				]

			]

		);

		$this->add_control( 'title_status',

			[

				'label' => esc_html__( 'Subtitle Show/Hide', 'flynext-core' ),

				'type' => Controls_Manager::SWITCHER,

				'description' => esc_html__( 'show/hide Subtitle', 'flynext-core' ),

			] );

		$this->add_control( 'title', [

			'label' => esc_html__( 'Title', 'flynext-core' ),

			'type' => Controls_Manager::TEXT,

			'default' => esc_html__( 'Projects Done', 'flynext-core' ),

			'description' => esc_html__( 'enter title', 'flynext-core' )

		] );

		$this->add_control( 'number', [

			'label' => esc_html__( 'Number', 'flynext-core' ),

			'type' => Controls_Manager::TEXT,

			'default' => esc_html__( '25', 'flynext-core' ),

			'description' => esc_html__( 'enter counterup number', 'flynext-core' )

		] );

		$this->add_control( 'sign', [

			'label' => esc_html__( 'sign', 'flynext-core' ),

			'type' => Controls_Manager::TEXT,

			'default' => esc_html__( 'k+', 'flynext-core' ),

			'description' => esc_html__( 'enter counterup sign', 'flynext-core' )

		] );


		$this->end_controls_section();


		$this->start_controls_section(

			'styling_settings_section',

			[

				'label' => esc_html__( 'Styling Settings', 'flynext-core' ),

				'tab' => Controls_Manager::TAB_STYLE,

			]

		);

		$this->add_control(

			'shape-radius',

			[

				'label' => esc_html__( 'Radius', 'flynext-core' ),

				'type' => Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', '%', 'em' ],

				'selectors' => [

					'{{WRAPPER}} .single-counterup-03' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				],

			]

		);

		$this->add_group_control(

			Group_Control_Box_Shadow::get_type(),

			[

				'name' => 'box_shadow',

				'label' => esc_html__( 'Box Shadow', 'flynext-core' ),

				'selector' => '{{WRAPPER}} .single-counterup-03',

			]

		);

		$this->add_group_control(

			Group_Control_Background::get_type(),

			[

				'name' => 'background',

				'label' => esc_html__( 'Background', 'flynext-core' ),

				'types' => [ 'classic', 'gradient', 'video' ],

				'selector' => '{{WRAPPER}} .single-counterup-03',

			]

		);

		$this->add_group_control(

			Group_Control_Border::get_type(),

			[

				'name' => 'border',

				'label' => esc_html__( 'Border', 'flynext-core' ),

				'selector' => '{{WRAPPER}} .single-counterup-03',

			]

		);
        $this->add_control( 'icon_color', [

            'label' => esc_html__( 'Icon Color', 'flynext-core' ),

            'type' => Controls_Manager::COLOR,

            'selectors' => [

                "{{WRAPPER}} .single-counterup-03 .content .icon" => "color: {{VALUE}}"

            ]

        ] );
		$this->add_control( 'number_color', [

			'label' => esc_html__( 'Number Color', 'flynext-core' ),

			'type' => Controls_Manager::COLOR,

			'selectors' => [

				"{{WRAPPER}} .single-counterup-03 .content .count-wrap .count-num" => "color: {{VALUE}}",

				"{{WRAPPER}} .single-counterup-03 .content .count-wrap " => "color: {{VALUE}}"

			]

		] );

		$this->add_control( 'sign_color', [

			'label' => esc_html__( 'Sign Color', 'flynext-core' ),

			'type' => Controls_Manager::COLOR,

			'selectors' => [

				"{{WRAPPER}} .single-counterup-03 .content .count-wrap .sing-plus" => "color: {{VALUE}}"

			]

		] );

		$this->add_control( 'title_color', [

			'label' => esc_html__( 'Title Color', 'flynext-core' ),

			'type' => Controls_Manager::COLOR,

			'selectors' => [

				"{{WRAPPER}} .single-counterup-03 .content .title" => "color: {{VALUE}}"

			]

		] );

		$this->end_controls_section();


		$this->start_controls_section(

			'typography_settings_section',

			[

				'label' => esc_html__( 'Typography Settings', 'flynext-core' ),

				'tab' => Controls_Manager::TAB_STYLE,

			]

		);

		$this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'number_typography',

				'label' => esc_html__( 'Number Typography', 'flynext-core' ),

				'selector' => '{{WRAPPER}} .single-counterup-03 .count-wrap',

			]

		);

		$this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'title_typography',

				'label' => esc_html__( 'Title Typography', 'flynext-core' ),

				'selector' => '{{WRAPPER}} .single-counterup-03 .title',

			]

		);

		$this->end_controls_section();

	}


	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */

	protected function render() {


		$settings = $this->get_settings_for_display();


		$title = $settings['title'];

		$number = $settings['number'];

		$this->add_render_attribute( 'counterup_wrapper', 'class', 'single-counterup-03' );

		$this->add_render_attribute( 'counterup_wrapper', 'class', $settings['theme'] );


		?>

        <div <?php echo $this->get_render_attribute_string( 'counterup_wrapper' ); ?>>
            <div class="content-wrap">
                <div class="content">
                    <div class="icon">
						<?php
						Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] );
						?>
                    </div>
                    <div class="count-wrap">
                        <span class="count-num"><?php echo esc_html( $number ); ?><sup><?php echo esc_html( $settings['sign'] ) ?></sup></span>
                    </div>
					<?php
					if ( ! empty( $settings['title_status'] ) ) : ?>
                        <h4 class="title"><?php echo esc_html( $title ); ?></h4>
                    <?php endif; ?>
                </div>
            </div>
        </div>

		<?php

	}

}


Plugin::instance()->widgets_manager->register_widget_type( new Flynext_Counterup_Two_Widget() );