<?php
/**
 * Elementor Widget
 * @package Flynext
 * @since 1.0.0
 */

namespace Elementor;
class Flynext_course_Slider_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'flynext-course-slider-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Course Item 01', 'flynext-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-post-slider';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['flynext_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'flynext-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'courses_system',
            [
                'label' => esc_html__('Courses Style System', 'flynext-core'),
                'type' => Controls_Manager::SELECT,
                'default' => 'for-slider',
                'options' => [
                    'for-grid' => esc_html__('Grid System', 'flynext-core'),
                    'for-slider' => esc_html__('Slider System', 'flynext-core'),
                ],
            ]
        );
        $this->add_control(
            'column',
            [
                'label' => esc_html__('Column', 'flynext-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    '6' => esc_html__('02 Column', 'flynext-core'),
                    '3' => esc_html__('04 Column', 'flynext-core'),
                    '4' => esc_html__('03 Column', 'flynext-core'),
                    '2' => esc_html__('06 Column', 'flynext-core')
                ),
                'description' => esc_html__('select grid column', 'flynext-core'),
                'default' => '4'
            ]
        );
        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'flynext-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many course you want in masonry , enter -1 for unlimited course.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'flynext-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => flynext()->get_terms_names('course-category', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'flynext-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'flynext-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'flynext-core'),
                'DESC' => esc_html__('Descending', 'flynext-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'flynext-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'flynext-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'flynext-core'),
                'title' => esc_html__('Title', 'flynext-core'),
                'date' => esc_html__('Date', 'flynext-core'),
                'rand' => esc_html__('Random', 'flynext-core'),
                'comment_count' => esc_html__('Most Comments', 'flynext-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'flynext-core')
        ]);
        $this->add_control('excerpt_length', [
            'label' => esc_html__('Excerpt Length', 'flynext-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                15 => esc_html__('Short', 'flynext-core'),
                55 => esc_html__('Regular', 'flynext-core'),
                100 => esc_html__('Long', 'flynext-core'),
            ),
            'default' => 15,
            'description' => esc_html__('select excerpt length', 'flynext-core')
        ]);
        $this->add_control('readmore_text', [
            'label' => esc_html__('Read More Text', 'flynext-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Read More', 'flynext-core')
        ]);
        $this->add_control(
            'pagination',
            [
                'label' => esc_html__('Pagination', 'flynext-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes to show pagination.', 'flynext-core'),
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'pagination_alignment',
            [
                'label' => esc_html__('Pagination Alignment', 'flynext-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'left' => esc_html__('Left Align', 'flynext-core'),
                    'center' => esc_html__('Center Align', 'flynext-core'),
                    'right' => esc_html__('Right Align', 'flynext-core'),
                ),
                'description' => esc_html__('you can set pagination alignment.', 'flynext-core'),
                'default' => 'left',
                'condition' => array('pagination' => 'yes')
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Slider Settings', 'flynext-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'items',
            [
                'label' => esc_html__('Items', 'flynext-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('you can set how many item show in slider', 'flynext-core'),
                'default' => '3'
            ]
        );
        $this->add_control(
            'loop',
            [
                'label' => esc_html__('Loop', 'flynext-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'flynext-core'),
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'flynext-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'flynext-core'),
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'nav_slider_position',
            [
                'label' => esc_html__('Slider Nav Position', 'flynext-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => -200,
                        'max' => 500,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => -120,
                ],
                'selectors' => [
                    '{{WRAPPER}} .blog-slider-controls .slider-nav' => 'bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'nav',
            [
                'label' => esc_html__('Nav', 'flynext-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'flynext-core'),
            ]
        );
        $this->add_control(
            'nav_position',
            [
                'label' => esc_html__('Nav Position', 'flynext-core'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('Normal', 'flynext-core'),
                    'style-01' => esc_html__('Top Position', 'flynext-core'),
                ],
            ]
        );
        $this->add_control(
            'nav_right_arrow',
            [
                'label' => esc_html__('Nav Right Icon', 'flynext-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'flynext-core'),
                'default' => [
                    'value' => 'fas fa-angle-right',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control(
            'nav_left_arrow',
            [
                'label' => esc_html__('Nav Left Icon', 'flynext-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'flynext-core'),
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control(
            'autoplaytimeout',
            [
                'label' => esc_html__('Autoplay Timeout', 'flynext-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10000,
                        'step' => 2,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5000,
                ],
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]

        );
        $this->end_controls_section();

        $this->start_controls_section(
            'styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'flynext-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'title_style_tabs'
        );

        $this->start_controls_tab(
            'title_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'flynext-core'),
            ]
        );
        $this->add_control('course_price_color', [
            'label' => esc_html__('Course Price Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .course-single-item .thumb .price" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('course_bg_price_color', [
            'label' => esc_html__('Course Price Background Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .course-single-item .thumb .price" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_control('course_duration_color', [
            'label' => esc_html__('Course Duration Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .course-single-item .content .tutor-single-loop-meta" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('content_bg_color', [
            'label' => esc_html__('Content Background Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .course-single-item .content" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .course-single-item .content .title" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('paragraph_typography', [
            'label' => esc_html__('Paragraph Color', 'flynext-core'),
            'description' => esc_html__('select Paragraph Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .course-single-item .content p" => "color: {{VALUE}}"
            ]
        ]);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'flynext-core'),
            ]
        );

        $this->add_control('title_hover_color', [
            'label' => esc_html__('Title Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .course-single-item .content .title:hover" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => esc_html__('Box Shadow', 'flynext-core'),
                'selector' => '{{WRAPPER}} .course-single-item:hover',
            ]
        );
        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        /* button styling */
        $this->start_controls_section('header_button_section', [
            'label' => esc_html__('Button Settings', 'flynext-core'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);

        $this->start_controls_tabs('button_styling');
        $this->start_controls_tab('normal_style', [
            'label' => esc_html__('Button Normal', "flynext-core")
        ]);
        $this->add_control('button_normal_color', [
            'label' => esc_html__('Button Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .course-single-item .content .add_to_cart_button" => "color: {{VALUE}}",
                "{{WRAPPER}} .course-single-item .content .added_to_cart" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('divider_01', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'button_background',
            'label' => esc_html__('Button Background ', 'flynext-core'),
            'selector' => "{{WRAPPER}} .course-single-item .content .add_to_cart_button,
            {{WRAPPER}} .course-single-item .content .added_to_cart"
        ]);

        $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'header_button_border',
            'label' => esc_html__('Border', 'flynext-core'),
            'selector' => "{{WRAPPER}} .course-single-item .content .add_to_cart_button,
            {{WRAPPER}} .course-single-item .content .added_to_cart"
        ]);
        $this->end_controls_tab();

        $this->start_controls_tab('hover_style', [
            'label' => esc_html__('Button Hover', "flynext-core")
        ]);
        $this->add_control('button_hover_normal_color', [
            'label' => esc_html__('Button Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .course-single-item .content .add_to_cart_button:hover" => "color: {{VALUE}}",
                "{{WRAPPER}} .course-single-item .content .added_to_cart:hover" => "color: {{VALUE}}",
            ]
        ]);
        $this->add_control('divider_03', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'button_hover_background',
            'label' => esc_html__('Button Background ', 'flynext-core'),
            'selector' => "{{WRAPPER}} .course-single-item .content .add_to_cart_button:hover,
            {{WRAPPER}} .course-single-item .content .added_to_cart:hover"
        ]);
        $this->add_control('divider_04', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control('divider_05', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__('Border Radius', 'flynext-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .course-single-item .content .add_to_cart_button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .course-single-item .content .added_to_cart' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        /* button styling end */


        /*  pagination styling tabs start */
        $this->start_controls_section(
            'pagination_settings_section',
            [
                'label' => esc_html__('Pagination Settings', 'flynext-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'pagination_style_tabs'
        );

        $this->start_controls_tab(
            'pagination_style_normal_tab',
            [
                'label' => __('Normal', 'flynext-core'),
            ]
        );

        $this->add_control('pagination_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Color', 'flynext-core'),
            'selectors' => [
                "{{WRAPPER}} .blog-pagination ul li a" => "color: {{VALUE}}",
                "{{WRAPPER}} .blog-pagination ul li span" => "color: {{VALUE}}",
            ]
        ]);
        $this->add_control('pagination_border_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Border Color', 'flynext-core'),
            'selectors' => [
                "{{WRAPPER}} .blog-pagination ul li a" => "border-color: {{VALUE}}",
                "{{WRAPPER}} .blog-pagination ul li span" => "border-color: {{VALUE}}",
            ]
        ]);
        $this->add_control('pagination_hr', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'pagination_background',
            'label' => esc_html__('Background', 'flynext-core'),
            'selector' => "{{WRAPPER}} .blog-pagination ul li a, {{WRAPPER}} .blog-pagination ul li span"
        ]);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'pagination_style_hover_tab',
            [
                'label' => __('Hover', 'flynext-core'),
            ]
        );
        $this->add_control('pagination_hover_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Color', 'flynext-core'),
            'selectors' => [
                "{{WRAPPER}} .blog-pagination ul li a:hover" => "color: {{VALUE}}",
                "{{WRAPPER}} .blog-pagination ul li span.current" => "color: {{VALUE}}",
            ]
        ]);
        $this->add_control('pagination_hover_border_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Border Color', 'flynext-core'),
            'selectors' => [
                "{{WRAPPER}} .blog-pagination ul li a:hover" => "border-color: {{VALUE}}",
                "{{WRAPPER}} .blog-pagination ul li span.current" => "border-color: {{VALUE}}",
            ]
        ]);
        $this->add_control('pagination_hover_hr', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'pagination_hover_background',
            'label' => esc_html__('Background', 'flynext-core'),
            'selector' => "{{WRAPPER}} .blog-pagination ul li a:hover, {{WRAPPER}} .blog-pagination ul li span.current"
        ]);


        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
        /*  pagination styling tabs end */


        $this->start_controls_section(
            'typography_settings_section',
            [
                'label' => esc_html__('Typography Settings', 'flynext-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'flynext-core'),
            'name' => 'title_typography',
            'description' => esc_html__('select title typography', 'flynext-core'),
            'selector' => "{{WRAPPER}} .course-single-item .content .title"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Paragraph Typography', 'flynext-core'),
            'name' => 'paragraph_typography',
            'description' => esc_html__('select Paragraph typography', 'flynext-core'),
            'selector' => "{{WRAPPER}} .course-single-item .content p"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Read More Typography', 'flynext-core'),
            'name' => 'read_more_typography',
            'description' => esc_html__('select Paragraph typography', 'flynext-core'),
            'selector' => "{{WRAPPER}}  .course-single-item .content-wrap .read-btn"
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $rand_numb = rand(333, 999999999);
        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];
        $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        //other settings
        $pagination = $settings['pagination'] ? false : true;
        $pagination_alignment = $settings['pagination_alignment'];
        //slider settings
        $slider_settings = [
            "loop" => esc_attr($settings['loop']),
            "margin" => esc_attr($settings['margin']['size'] ?? 0),
            "items" => esc_attr($settings['items'] ?? 1),
            "autoplay" => esc_attr($settings['autoplay']),
            "autoplaytimeout" => esc_attr($settings['autoplaytimeout']['size'] ?? 0),
            "nav" => esc_attr($settings['nav']),
            "navleft" => flynext_core()->render_elementor_icons($settings['nav_left_arrow']),
            "navright" => flynext_core()->render_elementor_icons($settings['nav_right_arrow'])
        ];
        //setup query
        $args = array(
            'post_type' => 'courses',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish'
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'course-category',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }

        $post_data = new \WP_Query($args);
        ?>
        <?php if ($settings['courses_system'] === 'for-grid') : ?>
        <div class="course-single-item-wrap">
            <div class="row">
                <?php
                while ($post_data->have_posts()):$post_data->the_post();
                    $image_url = get_tutor_course_thumbnail('flynext-grid', $url = true);
                    ?>
                    <div class="col-lg-<?php echo esc_attr($settings['column']); ?> col-md-6">
                        <div class="course-single-item margin-bottom-30">
                            <div class="thumb" style="background-image: url(<?php echo $image_url ?>)">
                                <?php
                                flynext_core()->tutor_price();
                                ?>

                            </div>
                            <div class="content">
                                <a href="<?php the_permalink(); ?>">
                                    <h4 class="title"><?php the_title(); ?></h4>
                                </a>
                                <?php
                                $course_duration = get_tutor_course_duration_context();
                                if (!empty($course_duration)) { ?>
                                    <div class="tutor-single-loop-meta">
                                        <i class='flaticon-repeat'></i>
                                        <span><?php echo $course_duration; ?></span>
                                    </div>
                                <?php } ?>
                                <?php Flynext_Excerpt($settings['excerpt_length']) ?>
                                <?php
                                if (flynext_core()->is_woocommerce_active()) {
                                    flynext_core()->tutor_enroll_btn();
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                <?php
                endwhile;
                wp_reset_query();
                ?>
                <div class="col-lg-12">
                    <div class="blog-pagination text-<?php echo esc_attr($pagination_alignment) ?> margin-top-20">
                        <?php
                        if (!$pagination) {
                            flynext()->post_pagination($post_data);
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
        <?php if ($settings['courses_system'] === 'for-slider') : ?>
        <div class="course-carousel-one-wrapper">
            <div class="course-grid-carousel performance-carousel"
                 id="course-grid-one-carousel-<?php echo esc_attr($rand_numb); ?>"
                 data-settings='<?php echo json_encode($slider_settings) ?>'
            >
                <?php
                while ($post_data->have_posts()):$post_data->the_post();
                    $image_url = get_tutor_course_thumbnail('flynext-full', $url = true);
                    ?>
                    <div class="course-outer-wrap">
                        <div class="course-single-item margin-bottom-30">
                            <div class="thumb" style="background-image: url(<?php echo esc_url($image_url) ?>)">
                                <?php
                                flynext_core()->tutor_price();
                                ?>

                            </div>
                            <div class="content">
                                <a href="<?php the_permalink(); ?>">
                                    <h4 class="title"><?php the_title(); ?></h4>
                                </a>
                                <?php
                                $course_duration = get_tutor_course_duration_context();
                                if (!empty($course_duration)) { ?>
                                    <div class="tutor-single-loop-meta">
                                        <i class='flaticon-repeat'></i>
                                        <span><?php echo $course_duration; ?></span>
                                    </div>
                                <?php } ?>
                                <?php Flynext_Excerpt($settings['excerpt_length']) ?>
                                <?php
                                if (flynext_core()->is_woocommerce_active()) {
                                    flynext_core()->tutor_enroll_btn();
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                <?php
                endwhile;
                wp_reset_query();
                ?>
            </div>
            <?php if (!empty($settings['nav'])) : ?>
                <div class="course-slider-controls">
                    <div class="slider-nav <?php echo $settings['nav_position'] ?>"></div>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Flynext_course_Slider_One_Widget());