<?php
/**
 * Elementor Widget
 * @package Appside
 * @since 1.0.0
 */

namespace Elementor;

class Flynext_History_Item_Widget extends Widget_Base

{
    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *

     */

    public function get_name()

    {
        return 'flynext-history-widget';

    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *

     */

    public function get_title()

    {
        return esc_html__('History Single Item', 'flynext-core');

    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *

     */

    public function get_icon()

    {
        return 'eicon-call-to-action';

    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *

     */

    public function get_categories()

    {
        return ['flynext_widgets'];

    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */

    protected function register_controls()

    {
        $this->start_controls_section(
            'settings_section', ['label' => esc_html__('General Settings', 'flynext-core'),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);
        $repeater = new Repeater();

        $repeater->add_control('year', [
            'default' => esc_html__('2012', 'flynext-core'),
            'label' => esc_html__('Year', 'flynext-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('Enter Year', 'flynext-core')
        ]);

        $repeater->add_control('title', [
            'label' => esc_html__('Title', 'flynext-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Criminal Law', 'flynext-core'),
            'description' => esc_html__('Enter title', 'flynext-core')
        ]);

        $repeater->add_control('description', [
            'default' => esc_html__('If you are accused of lot of committing a crime you need. Qui ipsorum lingua Celtae, nostra Galli appellantur', 'flynext-core'),
            'label' => esc_html__('Description', 'flynext-core'),
            'type' => Controls_Manager::TEXTAREA,
            'description' => esc_html__('Enter description', 'flynext-core')
        ]);

        $repeater->add_control('history_image', [
            'label' => esc_html__('Image', 'flynext-core'),
            'type' => Controls_Manager::MEDIA,
        ]);

        $this->add_control('history_items', [
            'label' => esc_html__('History Items', 'flynext-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'sub-title' => esc_html__('First case', 'flynext-core'),
                    'title' => esc_html__('Found case', 'flynext-core'),
                    'description' => esc_html__('Duis aute irure dolor reprehenderit in voluptate velit essle cillum dolore eu fugiat nulla pariatur. Excepteur sint ocaec at cupdatat proident suntin culpa qui officia deserunt mol anim id esa laborum perspiciat.', 'flynext-core'),
                ]
            ],
        ]);

        $this->end_controls_section();


        $this->start_controls_section('item_styling_settings_section',
            [
                'label' => esc_html__('Item Styling Settings', 'flynext-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]);

        $this->add_control('sub_title_color', [
            'label' => esc_html__('Year Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .history-single-item .content .sub-title" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .history-single-item .content .title" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('paragraph_color', [
            'label' => esc_html__('Paragraph Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .history-single-item .content p" => "color: {{VALUE}}"
            ]
        ]);
        $this->end_controls_section();
        $this->start_controls_section('wrap_styling_settings_section',
            [
                'label' => esc_html__('Wrap Styling Settings', 'flynext-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('border_color', [
            'label' => esc_html__('Border Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .history-single-item .dot" => "border-color: {{VALUE}}",
            ]
        ]);
        $this->add_control('cricle_border_color', [
            'label' => esc_html__('Cricle Border Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .history-single-item::after" => "background-color: {{VALUE}}",
            ]
        ]);
        $this->add_control('cricle_lite_border_color', [
            'label' => esc_html__('Cricle Line Border Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .history-single-item + .history-single-item::before" => "background-color: {{VALUE}}",
            ]
        ]);
        $this->end_controls_section();
        $this->start_controls_section('typography_settings_section',
            [
                'label' => esc_html__('Typography Settings', 'flynext-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__(' Year Typography', 'flynext-core'),
            'name' => 'since_year_typography',
            'description' => esc_html__('select year typography', 'flynext-core'),
            'selector' => "{{WRAPPER}}  .history-item-wrap .since-year"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__(' Sub Title Typography', 'flynext-core'),
            'name' => 'sub_title_typography',
            'description' => esc_html__('select title typography', 'flynext-core'),
            'selector' => "{{WRAPPER}}  .history-single-item .content .sub-title"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'flynext-core'),
            'name' => 'title_typography',
            'description' => esc_html__('select title typography', 'flynext-core'),
            'selector' => "{{WRAPPER}}  .history-single-item .content .title"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Paragraph Typography', 'flynext-core'),
            'name' => 'paragraph_typography',
            'description' => esc_html__('select title typography', 'flynext-core'),
            'selector' => "{{WRAPPER}}  .history-single-item .content p"
        ]);
        $this->end_controls_section();
        $this->start_controls_section(
            'padding_margin_settings_section',
            [
                'label' => esc_html__('Padding Settings', 'flynext-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('width',
            [
                'label' => __('Width', 'flynext-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 5,
                    ],
                    'px' => ['min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .history-single-item .content .title' => 'padding-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */

    protected function render()

    {
        $settings = $this->get_settings_for_display(); ?>
        <div class="history-item-wrap">
            <?php
            foreach ($settings['history_items'] as $item) :
                $image_id = $item['history_image']['id'];
                $image_url = !empty($image_id) ? wp_get_attachment_image_src($image_id, 'full')[0] : '';
                $image_alt = get_post_meta($image_id,'_wp_attachment_image_alt',true);
                ?>
                <div class="history-single-item">
                    <div class="history-single-item-content">
                        <div class="dot"></div>
                        <div class="thumb wow animated fadeInLeft">
                            <img src="<?php echo esc_url($image_url)?>" alt="<?php echo esc_attr($image_alt)?>">
                        </div>
                        <div class="content wow animated fadeInRight">
                        <span class="sub-title">
                            <?php echo esc_html($item['year']); ?>
                        </span>
                            <h4 class="title"> <?php echo esc_html($item['title']); ?></h4>
                            <p><?php echo esc_html($item['description']); ?></p>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Flynext_History_Item_Widget());

