<?php
/**
 * Elementor Widget
 * @package Flynext
 * @since 1.0.0
 */

namespace Elementor;
class Flynext_Packages_Single_Slider_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'flynext-packages-single-slider-two-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Packages Single Slider: 02', 'flynext-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-pojome';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['flynext_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {


        $this->start_controls_section(
            'video_settings_section',
            [
                'label' => esc_html__('Video Settings', 'flynext-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => esc_html__('Icon', 'flynext-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('select Icon.', 'flynext-core'),
                'default' => [
                    'value' => 'fas fa-play',
                    'library' => 'solid',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'flynext-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'deals_system',
            [
                'label' => esc_html__('Packages Style System', 'flynext-core'),
                'type' => Controls_Manager::SELECT,
                'default' => 'for-slider',
                'options' => [
                    'for-grid' => esc_html__('Grid System', 'flynext-core'),
                    'for-slider' => esc_html__('Slider System', 'flynext-core'),
                ],
            ]
        );
        $this->add_control(
            'column',
            [
                'label' => esc_html__('Column', 'flynext-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    '3' => esc_html__('04 Column', 'flynext-core'),
                    '4' => esc_html__('03 Column', 'flynext-core'),
                    '2' => esc_html__('06 Column', 'flynext-core')
                ),
                'condition' => ['deals_system' => 'for-grid'],
                'description' => esc_html__('select grid column', 'flynext-core'),
                'default' => '4'
            ]
        );

        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'flynext-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many course you want in masonry , enter -1 for unlimited course.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'flynext-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => flynext()->get_terms_names('packages-cat', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'flynext-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'flynext-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'flynext-core'),
                'DESC' => esc_html__('Descending', 'flynext-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'flynext-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'flynext-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'flynext-core'),
                'title' => esc_html__('Title', 'flynext-core'),
                'date' => esc_html__('Date', 'flynext-core'),
                'rand' => esc_html__('Random', 'flynext-core'),
                'comment_count' => esc_html__('Most Comments', 'flynext-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'flynext-core')
        ]);
        $this->add_control('readmore_text', [
            'label' => esc_html__('Read More Text', 'flynext-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Read More', 'flynext-core')
        ]);
        $this->end_controls_section();
        $this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Slider Settings', 'flynext-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'items',
            [
                'label' => esc_html__('Items', 'flynext-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('you can set how many item show in slider', 'flynext-core'),
                'default' => '3'
            ]
        );
        $this->add_control(
            'loop',
            [
                'label' => esc_html__('Loop', 'flynext-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'flynext-core'),
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'flynext-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'flynext-core'),
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'nav_slider_position',
            [
                'label' => esc_html__('Slider Nav Position', 'flynext-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => -200,
                        'max' => 500,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => -55,
                ],
                'selectors' => [
                    '{{WRAPPER}} .slick-carousel-controls .slider-nav.style-04' => 'bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'nav',
            [
                'label' => esc_html__('Nav', 'flynext-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'flynext-core'),
            ]
        );
        $this->add_control(
            'dots',
            [
                'label' => esc_html__('Dots', 'flynext-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'flynext-core'),
                'default' => 'no'
            ]
        );
        $this->add_control(
            'nav_right_arrow',
            [
                'label' => esc_html__('Nav Right Icon', 'flynext-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'flynext-core'),
                'default' => [
                    'value' => 'fas fa-angle-right',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control(
            'nav_left_arrow',
            [
                'label' => esc_html__('Nav Left Icon', 'flynext-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'flynext-core'),
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control(
            'autoplaytimeout',
            [
                'label' => esc_html__('Autoplay Timeout', 'flynext-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10000,
                        'step' => 2,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5000,
                ],
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]

        );
        $this->end_controls_section();


        $this->start_controls_section(
            'content_styling_section',
            [
                'label' => esc_html__('Content Styling', 'flynext-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'style_tabs'
        );

        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__('Normal', 'flynext-core'),
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => esc_html__('Box Shadow', 'flynext-core'),
                'selector' => '{{WRAPPER}} .single-packages-box',
            ]
        );
        $this->add_control('normal_background_color', [
            'label' => esc_html__('Background Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-packages-box .content-wrap" => "background-color: {{VALUE}};",
                "{{WRAPPER}} .single-packages-box" => "background-color: {{VALUE}};"
            ]
        ]);
        $this->add_control('normal_title_color', [
            'label' => esc_html__('Title Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-packages-box .title" => "color: {{VALUE}};"
            ]
        ]);
        $this->add_control('normal_description_color', [
            'label' => esc_html__('Description Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-packages-box .content .package-list li" => "color: {{VALUE}};"
            ]
        ]);
        $this->add_control(
            'item_padding',
            [
                'label' => esc_html__('Button Padding', 'flynext-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .btn-wrap .blank-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon_bg_color',
                'label' => esc_html__('Background Image', 'flynext-core'),
                'types' => ['classic', 'gradient', 'video'],
                'selector' => "{{WRAPPER}} .btn-wrap .blank-btn"
            ]
        );
        $this->add_control('button_color', [
            'label' => esc_html__('Button Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrap .blank-btn" => "color: {{VALUE}};"
            ]
        ]);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__('Hover', 'flynext-core'),
            ]
        );
        $this->add_control('hover_title_color', [
            'label' => esc_html__('Title Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-packages-box:hover .content .title" => "color: {{VALUE}};"
            ]
        ]);
        $this->add_control('hover_description_color', [
            'label' => esc_html__('Description Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-packages-box:hover .content p" => "color: {{VALUE}};"
            ]
        ]);
        $this->add_control('button_hover_color', [
            'label' => esc_html__('Button Hover Color', 'flynext-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrap .blank-btn:hover" => "color: {{VALUE}};"
            ]
        ]);
        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();


        /*  pagination styling tabs start */
        $this->start_controls_section(
            'pagination_settings_section',
            [
                'label' => esc_html__('Pagination Settings', 'flynext-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'pagination_style_tabs'
        );

        $this->start_controls_tab(
            'pagination_style_normal_tab',
            [
                'label' => __('Normal', 'flynext-core'),
            ]
        );

        $this->add_control('pagination_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Color', 'flynext-core'),
            'selectors' => [
                "{{WRAPPER}} .blog-pagination ul li a" => "color: {{VALUE}}",
                "{{WRAPPER}} .blog-pagination ul li span" => "color: {{VALUE}}",
            ]
        ]);
        $this->add_control('pagination_border_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Border Color', 'flynext-core'),
            'selectors' => [
                "{{WRAPPER}} .blog-pagination ul li a" => "border-color: {{VALUE}}",
                "{{WRAPPER}} .blog-pagination ul li span" => "border-color: {{VALUE}}",
            ]
        ]);
        $this->add_control('pagination_hr', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'pagination_background',
            'label' => esc_html__('Background', 'flynext-core'),
            'selector' => "{{WRAPPER}} .blog-pagination ul li a, {{WRAPPER}} .blog-pagination ul li span"
        ]);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'pagination_style_hover_tab',
            [
                'label' => __('Hover', 'flynext-core'),
            ]
        );
        $this->add_control('pagination_hover_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Color', 'flynext-core'),
            'selectors' => [
                "{{WRAPPER}} .blog-pagination ul li a:hover" => "color: {{VALUE}}",
                "{{WRAPPER}} .blog-pagination ul li span.current" => "color: {{VALUE}}",
            ]
        ]);
        $this->add_control('pagination_hover_border_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Border Color', 'flynext-core'),
            'selectors' => [
                "{{WRAPPER}} .blog-pagination ul li a:hover" => "border-color: {{VALUE}}",
                "{{WRAPPER}} .blog-pagination ul li span.current" => "border-color: {{VALUE}}",
            ]
        ]);
        $this->add_control('pagination_hover_hr', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'pagination_hover_background',
            'label' => esc_html__('Background', 'flynext-core'),
            'selector' => "{{WRAPPER}} .blog-pagination ul li a:hover, {{WRAPPER}} .blog-pagination ul li span.current"
        ]);


        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
        /*  pagination styling tabs end */


        /*  Dots styling tabs start */
        $this->start_controls_section(
            'dots_settings_section',
            [
                'label' => esc_html__('dots Settings', 'flynext-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'dots_style_tabs'
        );

        $this->start_controls_tab(
            'dots_style_normal_tab',
            [
                'label' => __('Normal', 'flynext-core'),
            ]
        );

        $this->add_control('dots_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Color', 'flynext-core'),
            'selectors' => [
                "{{WRAPPER}} .slick-carousel-controls .slick-dots li button" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_control('dots_border_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Border Color', 'flynext-core'),
            'selectors' => [
                "{{WRAPPER}} .slick-carousel-controls .slick-dots li button" => "border-color: {{VALUE}}"
            ]
        ]);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'dots_style_hover_tab',
            [
                'label' => __('Hover', 'flynext-core'),
            ]
        );
        $this->add_control('dots_hover_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Color', 'flynext-core'),
            'selectors' => [
                "{{WRAPPER}} .slick-carousel-controls .slick-dots li.slick-active button:after" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_control('dots_hover_border_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Border Color', 'flynext-core'),
            'selectors' => [
                "{{WRAPPER}} .slick-carousel-controls .slick-dots li.slick-active button" => "border-color: {{VALUE}}"
            ]
        ]);


        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
        /*  Dots styling tabs end */


        $this->start_controls_section(
            'typography_settings_section',
            [
                'label' => esc_html__('Typography Settings', 'flynext-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'title_typography',
            'label' => esc_html__('Title Typography', 'flynext-core'),
            'selector' => "{{WRAPPER}} .single-packages-box .title"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'button_typography',
            'label' => esc_html__('Button Typography', 'flynext-core'),
            'selector' => "{{WRAPPER}} .btn-wrap .blank-btn"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'description_typography',
            'label' => esc_html__('Description Typography', 'flynext-core'),
            'selector' => "{{WRAPPER}} .single-packages-box .content .package-list li"
        ]);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $rand_numb = rand(333, 999999999);
        //slider settings
        $slider_settings = [
            "loop" => esc_attr($settings['loop']),
            "margin" => esc_attr($settings['margin']['size'] ?? 0),
            "items" => esc_attr($settings['items'] ?? 1),
            "autoplay" => esc_attr($settings['autoplay']),
            "autoplaytimeout" => esc_attr($settings['autoplaytimeout']['size'] ?? 0),
            "dot" => esc_attr($settings['dots']),
            "nav" => esc_attr($settings['nav']),
            "navleft" => flynext_core()->render_elementor_icons($settings['nav_left_arrow']),
            "navright" => flynext_core()->render_elementor_icons($settings['nav_right_arrow'])
        ];
        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];
        //setup query
        $args = array(
            'post_type' => 'packages',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish'
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'packages-cat',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);

        ?>
        <?php if ($settings['deals_system'] === 'for-slider') : ?>
        <div class="packages-carousel-one-wrapper">
            <div class="packages-wrapper testimonial-carousel"
                 id="flynext-packages-wrapper-<?php echo esc_attr($rand_numb); ?>"
                 data-settings='<?php echo json_encode($slider_settings) ?>'>
                <?php
                while ($post_data->have_posts()) : $post_data->the_post();
                    $post_id = get_the_ID();
                    $img_id = get_post_thumbnail_id($post_id) ? get_post_thumbnail_id($post_id) : false;
                    $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'flynext_classic', false) : '';
                    $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                    $packages_single_meta_data = get_post_meta(get_the_ID(), 'flynext_packages_options', true);
                    ?>
                    <div class="packages-outer-wrap">
                        <div class="single-packages-box style-02">
                            <div class="thumb" style="background-image: url(<?php echo esc_url($img_url) ?>)">
                                <div class="price">
                                    <span> <?php echo $packages_single_meta_data['packages_price_option'] ?></span>
                                </div>
                            </div>
                            <div class="content">
                                <a href="<?php echo the_permalink() ?>">
                                    <h2 class="title"><?php echo esc_html(get_the_title($post_id)) ?></h2>
                                </a>
                                <ul class="package-list">
                                    <li><i class="flaticon-calendar"></i><?php echo $packages_single_meta_data['packages_date_option'] ?></li>
                                    <li><i class="flaticon-repeat"></i><?php echo $packages_single_meta_data['packages_duration_option'] ?></li>
                                    <li><i class="flaticon-user-4"></i><?php echo $packages_single_meta_data['packages_number_option'] ?></li>
                                </ul>
                                <div class="btn-wrap">
                                    <a href="<?php the_permalink() ?>"
                                       class="blank-btn"><i
                                                class="flaticon-black-plane"></i><?php echo esc_html__('Book Now', 'flynext-core'); ?>
                                    </a>
                                    <a href="<?php echo esc_url($packages_single_meta_data['packages_video_link']) ?>"
                                       class="button-video mfp-iframe"><?php echo flynext_core()->render_elementor_icons($settings['icon']) ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
            <div class="slick-carousel-controls">
                <?php if (!empty($settings['nav'])) : ?>
                    <div class="slider-nav style-04"></div>
                <?php endif; ?>
                <div class="slider-dots style-01"></div>
            </div>
        </div>
    <?php endif; ?>
        <?php if ($settings['deals_system'] === 'for-grid') : ?>
        <div class="deals-wrapper">
            <div class="row">
                <?php
                while ($post_data->have_posts()) : $post_data->the_post();
                    $post_id = get_the_ID();
                    $img_id = get_post_thumbnail_id($post_id) ? get_post_thumbnail_id($post_id) : false;
                    $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'flynext_gird', false) : '';
                    $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                    $packages_single_meta_data = get_post_meta(get_the_ID(), 'flynext_packages_options', true);
                    ?>
                    <div class="col-lg-<?php echo esc_attr($settings['column']); ?> col-md-6">
                        <div class="single-packages-box style-02 margin-bottom-30">
                            <div class="thumb" style="background-image: url(<?php echo esc_url($img_url) ?>)">
                                <div class="price">
                                    <span> <?php echo $packages_single_meta_data['packages_price_option'] ?></span>
                                </div>
                            </div>
                            <div class="content">
                                <a href="<?php echo the_permalink() ?>">
                                    <h2 class="title"><?php echo esc_html(get_the_title($post_id)) ?></h2>
                                </a>
                                <ul class="package-list">
                                    <li><i class="flaticon-calendar"></i><?php echo $packages_single_meta_data['packages_date_option'] ?></li>
                                    <li><i class="flaticon-repeat"></i><?php echo $packages_single_meta_data['packages_duration_option'] ?></li>
                                    <li><i class="flaticon-user-4"></i><?php echo $packages_single_meta_data['packages_number_option'] ?></li>
                                </ul>
                                <div class="btn-wrap">
                                    <a href="<?php the_permalink() ?>"
                                       class="blank-btn"><i
                                                class="flaticon-black-plane"></i><?php echo esc_html__('Book Now', 'flynext-core'); ?>
                                    </a>
                                    <a href="<?php echo esc_url($packages_single_meta_data['packages_video_link']) ?>"
                                       class="button-video mfp-iframe"><?php echo flynext_core()->render_elementor_icons($settings['icon']) ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>
    <?php endif; ?>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Flynext_Packages_Single_Slider_Two_Widget());