<?php
/*
Plugin Name: Flynext Core
Plugin URI: https://themeforest.net/user/themeim/portfolio
Description: Plugin to contain short codes and custom post types of the Flynext theme.
Author: Themeim
Author URI: https://themeim.com/
Version: 2.1.2
Text Domain: flynext-core
*/


/**
 * If this file is called directly, abort.
 * @package flynext
 * @since 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Plugin directory path
 * @package flynext
 * @since 1.0.0
 */
define( 'FLYNEXT_CORE_ROOT_PATH', plugin_dir_path( __FILE__ ) );
define( 'FLYNEXT_CORE_ROOT_URL', plugin_dir_url( __FILE__ ) );
define( 'FLYNEXT_CORE_SELF_PATH', 'flynext-core/flynext-core.php' );
define( 'FLYNEXT_CORE_VERSION', '2.1.2' );
define( 'FLYNEXT_CORE_INC', FLYNEXT_CORE_ROOT_PATH .'/inc');
define( 'FLYNEXT_CORE_LIB', FLYNEXT_CORE_ROOT_PATH .'/lib');
define( 'FLYNEXT_CORE_ELEMENTOR', FLYNEXT_CORE_ROOT_PATH .'/elementor');
define( 'FLYNEXT_CORE_DEMO_IMPORT', FLYNEXT_CORE_ROOT_PATH .'/demo-import');
define( 'FLYNEXT_CORE_ADMIN', FLYNEXT_CORE_ROOT_PATH .'/admin');
define( 'FLYNEXT_CORE_ADMIN_ASSETS', FLYNEXT_CORE_ROOT_URL .'admin/assets');
define( 'FLYNEXT_CORE_WP_WIDGETS', FLYNEXT_CORE_ROOT_PATH .'/wp-widgets');
define( 'FLYNEXT_CORE_ASSETS', FLYNEXT_CORE_ROOT_URL .'assets/');
define( 'FLYNEXT_CORE_CSS', FLYNEXT_CORE_ASSETS .'css');
define( 'FLYNEXT_CORE_JS', FLYNEXT_CORE_ASSETS .'js');
define( 'FLYNEXT_CORE_IMG', FLYNEXT_CORE_ASSETS .'img');


/**
 * Load additional helpers functions
 * @package flynext
 * @since 1.0.0
 */
if (!function_exists('flynext_core')){
	require_once FLYNEXT_CORE_INC .'/theme-core-helper-functions.php';
	if (!function_exists('flynext_core')){
		function flynext_core(){
			return class_exists('Flynext_Core_Helper_Functions') ? new Flynext_Core_Helper_Functions() : false;
		}
	}
}
//ob flash
remove_action( 'shutdown', 'wp_ob_end_flush_all', 1 );


/**
 * Load Codestar Framework Functions
 * @package flynext
 * @since 1.0.0
 */
if ( !flynext_core()->is_flynext_active()) {
	if ( file_exists( FLYNEXT_CORE_ROOT_PATH . '/inc/csf-functions.php' ) ) {
		require_once FLYNEXT_CORE_ROOT_PATH . '/inc/csf-functions.php';
	}
}



/**
 * Core Plugin Init
 * @package flynext
 * @since 1.0.0
 */
if ( file_exists( FLYNEXT_CORE_ROOT_PATH . '/inc/theme-core-init.php' ) ) {
	require_once FLYNEXT_CORE_ROOT_PATH . '/inc/theme-core-init.php';
}
