<?php
/**
 * Theme About Us Widget
 * @package Flynext
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('flynext_about_widget', array(
        'title' => esc_html__('Flynext: About Us', 'flynext-core'),
        'classname' => 'flynext-widget-about',
        'description' => esc_html__('Display about us widget', 'flynext-core'),
        'fields' => array(
            array(
                'id' => 'logo-area',
                'type' => 'media',
                'title' => esc_html__('Upload Your Photo', 'flynext-core'),
            ),
            array(
                'id' => 'description',
                'type' => 'textarea',
                'title' => esc_html__('Description', 'Flynext-core'),
                'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore.', 'flynext-core')
            ),

            array(
                'id' => 'flynext-footer-social-icon-repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Icon', 'flynext-core'),
                'fields' => array(

                    array(
                        'id' => 'flynext-footer-social-icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'flynext-core'),
                        'default' => 'flaticon-call'
                    ),
                    array(
                        'id' => 'flynext-footer-social-text',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Url', 'flynext-core'),
                        'default' => esc_html__('#', 'flynext-core')
                    ),

                ),
            ),
        )
    ));


    if (!function_exists('flynext_about_widget')) {
        function flynext_about_widget($args, $instance)
        {

            echo $args['before_widget'];

            // var_dump( $args ); // Widget arguments
            // var_dump( $instance ); // Saved values from database

            $instance['logo-area'];
            $logo = $instance['logo-area'];
            $img_id = $logo['id'] ?? '';
            $img_print = $img_id ? wp_get_attachment_image_src($img_id,'full')[0] : '';
            $alt_text = get_post_meta($img_id, '_wp_attachment_image_alt', true);
            $paragraph = $instance['description'] ?? '';
            $socialIcon = is_array($instance['flynext-footer-social-icon-repeater']) && !empty($instance['flynext-footer-social-icon-repeater']) ? $instance['flynext-footer-social-icon-repeater'] : [];


            ?>
            <div class="footer-widget widget">
                <div class="about_us_widget style-01">
                    <a href="<?php echo get_home_url(); ?>" class="footer-logo"><?php
                        if (!empty($img_print)) {
                            printf('<img src="%1$s" alt="%2$s"/>', esc_url($img_print), esc_attr($alt_text));
                        }
                        ?></a>
                    <p> <?php echo $paragraph; ?></p>
                    <ul class="contact_info_list">
                        <?php
                        foreach ($socialIcon as $icon) {
                            echo '<li class="single-info-item">
                            <div class="icon"><a href="'.$icon['flynext-footer-social-text'].'">
                                <i class="' . $icon['flynext-footer-social-icon'] . '"></i></a>
                            </div>
                        </li>';
                        };
                        ?>
                    </ul>
                </div>
            </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>