<?php
/**
 * Theme Social Share Widget
 * @package Flynext
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('flynext_social_share_widget', array(
        'title' => esc_html__('Flynext: Social Share', 'flynext-core'),
        'classname' => 'flynext-social-share-about',
        'description' => esc_html__('Display Social Share widget', 'flynext-core'),
        'fields' => array(
            array(
                'id' => 'heading',
                'type' => 'text',
                'title' => esc_html__('Enter Your Header Title', 'flynext-core'),
                'default' => esc_html__('Never Miss News', 'flynext-core')
            ),
            array(
                'id' => 'flynext-social-icon-repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Icon', 'flynext-core'),
                'fields' => array(
                    array(
                        'id' => 'flynext-social-icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'flynext-core'),
                        'default' => 'fab fa-facebook'
                    ),
                    array(
                        'id' => 'flynext-social-text',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Ulr', 'flynext-core'),
                        'default' => '#'
                    ),
                ),
            ),
        )
    ));


    if (!function_exists('flynext_social_share_widget')) {
        function flynext_social_share_widget($args, $instance)
        {

            echo $args['before_widget'];
            

            $heading_title = $instance['heading'] ?? '';
            $socialIcon = is_array($instance['flynext-social-icon-repeater']) && !empty($instance['flynext-social-icon-repeater']) ? $instance['flynext-social-icon-repeater'] : [];


            ?>
            <div class="social-share-widget">
                <h4 class="widget-headline"><?php echo esc_html($heading_title); ?></h4>
                <ul class="social-icon style-03">
                    <?php
                    foreach ($socialIcon as $icon) {
                        printf('<li><a href="%2$s"><i class="%1$s"></i></a></li>', esc_html($icon['flynext-social-icon']), esc_url($icon['flynext-social-text']));
                    };
                    ?>
                </ul>
            </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>