<?php
/**
 * Footer Style 01
 * @package flynext
 * @since 1.0.0
 */

$copyright_text = !empty(cs_get_option('copyright_text')) ? cs_get_option('copyright_text') : esc_html__('Fly Next Airlines. All rights reserved. ', 'flynext') . '<a href="' . esc_url('https://themeforest.net/user/themeim/portfolio') . '">' . esc_html__('Themeim', 'flynext') . '</a>';
$copyright_text = str_replace('{copy}', '&copy;', $copyright_text);
$copyright_text = str_replace('{year}', date('Y'), $copyright_text);
$socialIcon = cs_get_option('footer_three_social_repeater');
$footer_three_widget = cs_get_option('footer_three_top_repeater');

?>
<!-- footer area start -->
<div class="footer-style-03">
    <footer class="footer-wrap bg-image">
        <div class="footer-top">
            <div class="container">
                <div class="row">
                    <?php dynamic_sidebar('footer-widget-three'); ?>
                </div>
            </div>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="footer-top-widget-wrap">
                        <?php
                        if (!empty($footer_three_widget)):
                            foreach ($footer_three_widget as $widget): ?>
                                <div class="footer-nav-widget">
                                    <h3 class="widget-headline">
                                        <?php echo esc_html($widget['footer_three_top_item_title']) ?>
                                    </h3>
                                    <?php
                                    $paragraph = explode("\n", $widget['footer_three_social_icon_item_paragraph']);
                                    foreach ($paragraph as $detail) {
                                        printf('<p >%1$s</p>', esc_html($detail));
                                    }
                                    ?>
                                </div>
                            <?php
                            endforeach;
                        endif;
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="copyright-wrap">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="copyright-wrap-inner style-01">
                            <ul class="social_share">
                                <?php
                                if (!empty($socialIcon)) :
                                    foreach ($socialIcon as $icon) :
                                        echo '<li class="single-info-item"><a href=" ' . $icon['footer_three_social_icon_item_url'] . ' ">
                                                <i class="' . $icon['footer_three_social_icon_item_icon'] . '"></i></a></li>';
                                    endforeach;
                                endif;
                                ?>
                            </ul>
                            <div class="copyright-text">
                                <?php
                                echo wp_kses($copyright_text, flynext()->kses_allowed_html(array('a')));
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
</div>
<!-- footer area end -->